/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import mage.MageItem;
import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.common.delayed.AtTheBeginOfNextEndStepDelayedTriggeredAbility;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.SacrificeTargetEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.keyword.HasteAbility;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.target.targetpointer.FixedTargets;
import mage.target.targetpointer.TargetPointer;

class PullEffect
extends OneShotEffect {
    PullEffect() {
        super(Outcome.PutCardInPlay);
        this.staticText = "Put up to two target creature cards from a single graveyard onto the battlefield under your control. They gain haste until end of turn. Sacrifice them at the beginning of the next end step.";
    }

    private PullEffect(PullEffect effect) {
        super((OneShotEffect)effect);
    }

    public PullEffect copy() {
        return new PullEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Set cards = this.getTargetPointer().getTargets(game, source).stream().map(arg_0 -> ((Game)game).getCard(arg_0)).filter(Objects::nonNull).collect(Collectors.toSet());
        if (controller == null || cards.isEmpty() || !controller.moveCards(cards, Zone.BATTLEFIELD, source, game)) {
            return false;
        }
        Set permanents = cards.stream().map(MageItem::getId).map(arg_0 -> ((Game)game).getPermanent(arg_0)).filter(Objects::nonNull).collect(Collectors.toSet());
        if (permanents.isEmpty()) {
            return false;
        }
        GainAbilityTargetEffect effect = new GainAbilityTargetEffect((Ability)HasteAbility.getInstance());
        effect.setTargetPointer((TargetPointer)new FixedTargets(permanents, game));
        game.addEffect((ContinuousEffect)effect, source);
        SacrificeTargetEffect sacrificeEffect = new SacrificeTargetEffect("sacrifice them", controller.getId());
        sacrificeEffect.setTargetPointer((TargetPointer)new FixedTargets(permanents, game));
        game.addDelayedTriggeredAbility((DelayedTriggeredAbility)new AtTheBeginOfNextEndStepDelayedTriggeredAbility((Effect)sacrificeEffect), source);
        return true;
    }
}

