/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class PulseOfTheDrossReturnToHandEffect
extends OneShotEffect {
    PulseOfTheDrossReturnToHandEffect() {
        super(Outcome.Benefit);
        this.staticText = "Then if that player has more cards in hand than you, return {this} to its owner's hand";
    }

    private PulseOfTheDrossReturnToHandEffect(PulseOfTheDrossReturnToHandEffect effect) {
        super((OneShotEffect)effect);
    }

    public PulseOfTheDrossReturnToHandEffect copy() {
        return new PulseOfTheDrossReturnToHandEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player;
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null && (player = game.getPlayer(source.getFirstTarget())) != null) {
            if (player.getHand().size() > controller.getHand().size()) {
                Card card = game.getCard(source.getSourceId());
                controller.moveCards(card, Zone.HAND, source, game);
            }
            return true;
        }
        return false;
    }
}

