/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.ComparisonType;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.PowerPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class PuppetsVerdictEffect
extends OneShotEffect {
    PuppetsVerdictEffect() {
        super(Outcome.Damage);
        this.staticText = "Flip a coin. If you win the flip, destroy all creatures with power 2 or less. If you lose the flip, destroy all creatures with power 3 or greater";
    }

    private PuppetsVerdictEffect(PuppetsVerdictEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            if (controller.flipCoin(source, game, true)) {
                FilterCreaturePermanent filterPower2OrLess = new FilterCreaturePermanent("all creatures power 2 or less");
                filterPower2OrLess.add((Predicate)new PowerPredicate(ComparisonType.FEWER_THAN, 3));
                for (Permanent permanent : game.getBattlefield().getActivePermanents((FilterPermanent)filterPower2OrLess, source.getControllerId(), source, game)) {
                    permanent.destroy(source, game, false);
                }
                return true;
            }
            FilterCreaturePermanent filterPower3OrGreater = new FilterCreaturePermanent("all creatures power 3 or greater");
            filterPower3OrGreater.add((Predicate)new PowerPredicate(ComparisonType.MORE_THAN, 2));
            for (Permanent permanent : game.getBattlefield().getActivePermanents((FilterPermanent)filterPower3OrGreater, source.getControllerId(), source, game)) {
                permanent.destroy(source, game, false);
            }
            return true;
        }
        return false;
    }

    public PuppetsVerdictEffect copy() {
        return new PuppetsVerdictEffect(this);
    }
}

