/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.common.delayed.AtTheBeginOfNextEndStepDelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.SacrificeTargetEffect;
import mage.cards.Card;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.common.FilterCreatureCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.mageobject.ColorPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInHand;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;

class PurphurosBronzeBloodedEffect
extends OneShotEffect {
    private static final String choiceText = "Put a red creature card or an artifact creature card from your hand onto the battlefield?";
    private static final FilterCard filter = new FilterCreatureCard("a red creature card or an artifact creature card");

    PurphurosBronzeBloodedEffect() {
        super(Outcome.Benefit);
        this.staticText = "You may put a red creature card or an artifact creature card from your hand onto the battlefield. Sacrifice it at the beginning of the next end step";
    }

    private PurphurosBronzeBloodedEffect(PurphurosBronzeBloodedEffect effect) {
        super((OneShotEffect)effect);
    }

    public PurphurosBronzeBloodedEffect copy() {
        return new PurphurosBronzeBloodedEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null || !controller.chooseUse(Outcome.PutCreatureInPlay, choiceText, source, game)) {
            return true;
        }
        TargetCardInHand target = new TargetCardInHand(filter);
        if (!controller.choose(Outcome.PutCreatureInPlay, (Target)target, source, game)) {
            return true;
        }
        Card card = game.getCard(target.getFirstTarget());
        if (card == null || !controller.moveCards(card, Zone.BATTLEFIELD, source, game)) {
            return false;
        }
        Permanent permanent = CardUtil.getPermanentFromCardPutToBattlefield((Card)card, (Game)game);
        if (permanent == null) {
            return true;
        }
        game.addDelayedTriggeredAbility((DelayedTriggeredAbility)new AtTheBeginOfNextEndStepDelayedTriggeredAbility((Effect)new SacrificeTargetEffect("sacrifice " + card.getName(), source.getControllerId()).setTargetPointer((TargetPointer)new FixedTarget(permanent, game))), source);
        return true;
    }

    static {
        filter.add(Predicates.or((Predicate)CardType.ARTIFACT.getPredicate(), (Predicate)new ColorPredicate(ObjectColor.RED)));
    }
}

