/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.common.SpellCastAllTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.discard.DiscardTargetEffect;
import mage.filter.FilterSpell;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.mageobject.ColorPredicate;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;
import mage.game.stack.StackObject;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class PutrefactionTriggeredAbility
extends SpellCastAllTriggeredAbility {
    private static final FilterSpell filterGreenOrWhiteSpell = new FilterSpell("green or white spell");

    public PutrefactionTriggeredAbility() {
        super((Effect)new DiscardTargetEffect(1), filterGreenOrWhiteSpell, false);
    }

    private PutrefactionTriggeredAbility(PutrefactionTriggeredAbility ability) {
        super((SpellCastAllTriggeredAbility)ability);
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Spell spell;
        if (event.getType() == GameEvent.EventType.SPELL_CAST && (spell = game.getStack().getSpell(event.getTargetId())) != null && filterGreenOrWhiteSpell.match((StackObject)spell, this.getControllerId(), (Ability)this, game)) {
            ((Effect)this.getEffects().get(0)).setTargetPointer((TargetPointer)new FixedTarget(event.getPlayerId()));
            return true;
        }
        return false;
    }

    public PutrefactionTriggeredAbility copy() {
        return new PutrefactionTriggeredAbility(this);
    }

    static {
        filterGreenOrWhiteSpell.add(Predicates.or((Predicate)new ColorPredicate(ObjectColor.GREEN), (Predicate)new ColorPredicate(ObjectColor.WHITE)));
    }
}

