/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.util.CardUtil;

class PyromancersSwathReplacementEffect
extends ReplacementEffectImpl {
    PyromancersSwathReplacementEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "If an instant or sorcery source you control would deal damage to a permanent or player, it deals that much damage plus 2 to that permanent or player instead";
    }

    private PyromancersSwathReplacementEffect(PyromancersSwathReplacementEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        switch (event.getType()) {
            case DAMAGE_PERMANENT: 
            case DAMAGE_PLAYER: {
                return true;
            }
        }
        return false;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        if (source.isControlledBy(game.getControllerId(event.getSourceId()))) {
            MageObject object = game.getObject(event.getSourceId());
            return object != null && object.isInstantOrSorcery(game);
        }
        return false;
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        event.setAmount(CardUtil.overflowInc((int)event.getAmount(), (int)2));
        return false;
    }

    public PyromancersSwathReplacementEffect copy() {
        return new PyromancersSwathReplacementEffect(this);
    }
}

