/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.counters.Counter;
import mage.counters.CounterType;
import mage.counters.Counters;
import mage.game.Game;
import mage.players.Player;

class PyrrhicRevivalEffect
extends OneShotEffect {
    PyrrhicRevivalEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "Each player returns each creature card from their graveyard to the battlefield with an additional -1/-1 counter on it";
    }

    private PyrrhicRevivalEffect(PyrrhicRevivalEffect effect) {
        super((OneShotEffect)effect);
    }

    public PyrrhicRevivalEffect copy() {
        return new PyrrhicRevivalEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        Set toBattlefield = game.getState().getPlayersInRange(source.getControllerId(), game).stream().map(arg_0 -> ((Game)game).getPlayer(arg_0)).filter(Objects::nonNull).flatMap(p -> p.getGraveyard().getCards(game).stream()).filter(c -> c != null && c.isCreature(game)).collect(Collectors.toSet());
        Counters counters = new Counters(new Counter[0]);
        counters.addCounter(CounterType.M1M1.createInstance());
        for (Card card : toBattlefield) {
            game.setEnterWithCounters(card.getId(), counters.copy());
        }
        controller.moveCards(toBattlefield, Zone.BATTLEFIELD, source, game, false, false, true, null);
        return true;
    }
}

