/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.CardUtil;

class PyxisOfPandemoniumExileEffect
extends OneShotEffect {
    PyxisOfPandemoniumExileEffect() {
        super(Outcome.Detriment);
        this.staticText = "Each player exiles the top card of their library face down";
    }

    private PyxisOfPandemoniumExileEffect(PyxisOfPandemoniumExileEffect effect) {
        super((OneShotEffect)effect);
    }

    public PyxisOfPandemoniumExileEffect copy() {
        return new PyxisOfPandemoniumExileEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent pyxis = game.getPermanentOrLKIBattlefield(source.getSourceId());
        if (pyxis != null && controller != null) {
            HashMap exileIds;
            String valueKey = CardUtil.getObjectZoneString((String)"exileIds", (MageObject)pyxis, (Game)game);
            Object object = game.getState().getValue(valueKey);
            if (object instanceof Map) {
                exileIds = (HashMap)object;
            } else {
                exileIds = new HashMap();
                game.getState().setValue(valueKey, exileIds);
            }
            game.getState().getPlayersInRange(controller.getId(), game).forEach(playerId -> {
                Player player = game.getPlayer(playerId);
                if (player != null && player.getLibrary().hasCards()) {
                    Card card = player.getLibrary().getFromTop(game);
                    String exileKey = playerId.toString() + CardUtil.getExileZoneId((Game)game, (UUID)source.getSourceId(), (int)pyxis.getZoneChangeCounter(game));
                    UUID exileId = exileIds.computeIfAbsent(exileKey, k -> UUID.randomUUID());
                    player.moveCardsToExile(card, source, game, false, exileId, pyxis.getIdName() + " (" + player.getName() + ')');
                    card.setFaceDown(true, game);
                }
            });
            return true;
        }
        return false;
    }
}

