/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.search.SearchLibraryPutInHandEffect;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.mageobject.NamePredicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.common.TargetCardInLibrary;

class RegularExpression
extends OneShotEffect {
    RegularExpression() {
        super(Outcome.Benefit);
        this.staticText = "search your library for a card with the same name as another creature you control, reveal it, put it into your hand, then shuffle.";
    }

    private RegularExpression(RegularExpression effect) {
        super((OneShotEffect)effect);
    }

    public RegularExpression copy() {
        return new RegularExpression(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        List predicates = game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_CONTROLLED_ANOTHER_CREATURE, source.getControllerId(), source, game).stream().map(MageObject::getName).filter(Objects::nonNull).filter(s -> !s.isEmpty()).map(NamePredicate::new).collect(Collectors.toList());
        FilterCard filter = new FilterCard("a creature card with the same name as another creature you control");
        filter.add(Predicates.or(predicates));
        return new SearchLibraryPutInHandEffect(new TargetCardInLibrary(filter), true).apply(game, source);
    }
}

