/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.q;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class QuagFeastEffect
extends OneShotEffect {
    QuagFeastEffect() {
        super(Outcome.Benefit);
        this.staticText = "choose target creature, planeswalker, or Vehicle. Mill two cards, then destroy the chosen permanent if its mana value is less than or equal to the number of cards in your graveyard";
    }

    private QuagFeastEffect(QuagFeastEffect effect) {
        super((OneShotEffect)effect);
    }

    public QuagFeastEffect copy() {
        return new QuagFeastEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        player.millCards(2, source, game);
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (permanent != null && permanent.getManaValue() <= player.getGraveyard().size()) {
            permanent.destroy(source, game);
        }
        return true;
    }
}

