/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.q;

import java.util.Optional;
import java.util.Set;
import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.players.Player;

class QuantumRiddlerReplacementEffect
extends ReplacementEffectImpl {
    QuantumRiddlerReplacementEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Neutral);
        this.staticText = "as long as you have one or fewer cards in hand, if you would draw one or more cards, you draw that many cards plus one instead";
    }

    private QuantumRiddlerReplacementEffect(QuantumRiddlerReplacementEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public QuantumRiddlerReplacementEffect copy() {
        return new QuantumRiddlerReplacementEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DRAW_CARD;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean applies(GameEvent event, Ability source, Game game) {
        if (!source.isControlledBy(event.getPlayerId())) {
            return false;
        }
        if (!source.isControlledBy(event.getPlayerId())) return false;
        if (!Optional.ofNullable(event).map(GameEvent::getPlayerId).map(arg_0 -> ((Game)game).getPlayer(arg_0)).map(Player::getHand).map(Set::size).filter(x -> x <= 1).isPresent()) return false;
        return true;
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Optional.ofNullable(event).map(GameEvent::getPlayerId).map(arg_0 -> ((Game)game).getPlayer(arg_0)).ifPresent(player -> player.drawCards(2, source, game, event));
        return true;
    }
}

