/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.q;

import java.util.Map;
import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.CreateTokenEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.token.SoldierToken;
import mage.game.permanent.token.Token;

class QueenAllenalOfRuadachEffect
extends ReplacementEffectImpl {
    QueenAllenalOfRuadachEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "If one or more creature tokens would be created under your control, those tokens plus a 1/1 white Soldier creature token are created instead.";
    }

    private QueenAllenalOfRuadachEffect(QueenAllenalOfRuadachEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public QueenAllenalOfRuadachEffect copy() {
        return new QueenAllenalOfRuadachEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.CREATE_TOKEN;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        if (source.isControlledBy(event.getPlayerId())) {
            for (Map.Entry entry : ((CreateTokenEvent)event).getTokens().entrySet()) {
                if ((Integer)entry.getValue() <= 0 || !((Token)entry.getKey()).isCreature(game)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Map tokens = ((CreateTokenEvent)event).getTokens();
        for (Map.Entry entry : tokens.entrySet()) {
            if (!(entry.getKey() instanceof SoldierToken)) continue;
            entry.setValue((Integer)entry.getValue() + 1);
            return false;
        }
        tokens.put(new SoldierToken(), 1);
        return false;
    }
}

