/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.q;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;
import mage.watchers.Watcher;

class QuickenWatcher
extends Watcher {
    private List<String> activeQuickenSpells = new ArrayList<String>();

    public QuickenWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        Spell spell;
        if (event.getType() == GameEvent.EventType.SPELL_CAST && !this.activeQuickenSpells.isEmpty() && event.getPlayerId().equals(this.getControllerId()) && (spell = game.getStack().getSpell(event.getTargetId())) != null && spell.isSorcery(game)) {
            this.activeQuickenSpells.clear();
        }
    }

    public void addQuickenSpell(UUID playerId, UUID sourceId, int zoneChangeCounter) {
        String spellKey = playerId.toString() + sourceId.toString() + '_' + zoneChangeCounter;
        this.activeQuickenSpells.add(spellKey);
    }

    public boolean isQuickenSpellActive(UUID playerId, UUID sourceId, int zoneChangeCounter) {
        String spellKey = playerId.toString() + sourceId.toString() + '_' + zoneChangeCounter;
        return this.activeQuickenSpells.contains(spellKey);
    }

    public void reset() {
        super.reset();
        this.activeQuickenSpells.clear();
    }
}

