/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.q;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.asthought.PlayFromNotOwnHandZoneTargetEffect;
import mage.cards.Card;
import mage.cards.q.QuintoriusLoremasterReplacementEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.TargetController;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class QuintoriusLoremasterEffect
extends OneShotEffect {
    QuintoriusLoremasterEffect() {
        super(Outcome.Benefit);
        this.staticText = "choose target card exiled with {this}. You may cast that card this turn without paying its mana cost. If that spell would be put into a graveyard, put it on the bottom of its owner's library instead";
    }

    private QuintoriusLoremasterEffect(QuintoriusLoremasterEffect effect) {
        super((OneShotEffect)effect);
    }

    public QuintoriusLoremasterEffect copy() {
        return new QuintoriusLoremasterEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Card card = game.getCard(this.getTargetPointer().getFirst(game, source));
        if (player == null || card == null) {
            return false;
        }
        game.addEffect(new PlayFromNotOwnHandZoneTargetEffect(Zone.EXILED, TargetController.YOU, Duration.EndOfTurn, true).setTargetPointer((TargetPointer)new FixedTarget(card, game)), source);
        game.addEffect((ContinuousEffect)new QuintoriusLoremasterReplacementEffect(card, game), source);
        return true;
    }
}

