/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.q;

import java.util.Optional;
import java.util.UUID;
import mage.abilities.Ability;
import mage.cards.Card;
import mage.filter.predicate.ObjectSourcePlayer;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.game.Game;
import mage.game.GameState;
import mage.game.permanent.Permanent;
import mage.util.CardUtil;

enum QuintoriusLoremasterPredicate implements ObjectSourcePlayerPredicate<Card>
{
    instance;


    public boolean apply(ObjectSourcePlayer<Card> input, Game game) {
        return Optional.of(game).map(Game::getState).map(GameState::getExile).map(exile -> {
            Ability source = input.getSource();
            Permanent quintorius = source.getSourcePermanentOrLKI(game);
            if (quintorius == null) {
                return null;
            }
            UUID exileZoneId = CardUtil.getExileZoneId((Game)game, (UUID)quintorius.getId(), (int)quintorius.getZoneChangeCounter(game));
            return exile.getExileZone(exileZoneId);
        }).map(exile -> exile.contains((Object)((Card)input.getObject()).getId())).orElse(false);
    }
}

