/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class BelieveEffect
extends OneShotEffect {
    BelieveEffect() {
        super(Outcome.PutCardInPlay);
        this.staticText = "Look at the top card of your library. You may put it onto the battlefield if it's a creature card. If you don't, put it into your hand";
    }

    private BelieveEffect(BelieveEffect effect) {
        super((OneShotEffect)effect);
    }

    public BelieveEffect copy() {
        return new BelieveEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            Card card = controller.getLibrary().getFromTop(game);
            if (card != null) {
                if (card.isCreature(game) && controller.chooseUse(this.outcome, "Put " + card.getIdName() + " onto the battlefield?", source, game)) {
                    controller.moveCards(card, Zone.BATTLEFIELD, source, game);
                } else {
                    controller.moveCards(card, Zone.HAND, source, game);
                }
            }
            return true;
        }
        return false;
    }
}

