/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.Set;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.token.ResearchDevelopmentToken;
import mage.game.permanent.token.Token;
import mage.players.Player;

class DevelopmentEffect
extends OneShotEffect {
    DevelopmentEffect() {
        super(Outcome.Benefit);
        this.staticText = "Create a 3/1 red Elemental creature token unless any opponent has you draw a card. Repeat this process two more times.";
    }

    private DevelopmentEffect(DevelopmentEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player != null) {
            for (int i = 0; i < 3; ++i) {
                Set opponents = game.getOpponents(source.getControllerId());
                boolean putToken = true;
                for (UUID opponentUuid : opponents) {
                    Player opponent = game.getPlayer(opponentUuid);
                    if (opponent == null || !opponent.chooseUse(Outcome.Detriment, "Allow " + player.getLogName() + " to draw a card instead? (" + (i + 1) + ')', source, game)) continue;
                    game.informPlayers(opponent.getLogName() + " had chosen to let " + player.getLogName() + " draw a card.");
                    player.drawCards(1, source, game);
                    putToken = false;
                    break;
                }
                if (!putToken) continue;
                new CreateTokenEffect((Token)new ResearchDevelopmentToken()).apply(game, source);
            }
            return true;
        }
        return false;
    }

    public DevelopmentEffect copy() {
        return new DevelopmentEffect(this);
    }
}

