/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class RacklingEffect
extends OneShotEffect {
    RacklingEffect() {
        super(Outcome.Benefit);
        this.staticText = "{this} deals X damage to that player, where X is 3 minus the number of cards in their hand";
    }

    private RacklingEffect(RacklingEffect effect) {
        super((OneShotEffect)effect);
    }

    public RacklingEffect copy() {
        return new RacklingEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (player != null) {
            int damage = 3 - player.getHand().size();
            if (damage > 0) {
                player.damage(damage, source.getSourceId(), source, game);
            }
            return true;
        }
        return false;
    }
}

