/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.Ability;
import mage.abilities.costs.common.SacrificeTargetCost;
import mage.abilities.effects.OneShotEffect;
import mage.choices.Choice;
import mage.choices.ChoiceColor;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class RadiantLotusEffect
extends OneShotEffect {
    public RadiantLotusEffect() {
        super(Outcome.AIDontUseIt);
        this.staticText = "Choose a color. Target player adds three mana of the chosen color for each artifact sacrificed this way";
    }

    public RadiantLotusEffect(RadiantLotusEffect effect) {
        super((OneShotEffect)effect);
    }

    public RadiantLotusEffect copy() {
        return new RadiantLotusEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        String mes;
        ChoiceColor choice;
        int manaCount = source.getCosts().stream().filter(SacrificeTargetCost.class::isInstance).mapToInt(cost -> ((SacrificeTargetCost)cost).getPermanents().size() * 3).sum();
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null && controller.choose(this.outcome, (Choice)(choice = new ChoiceColor(true, mes = String.format("Select a color of mana to add %d of it", manaCount), game.getObject(source))), game)) {
            Player player = game.getPlayer(source.getFirstTarget());
            if (choice.getColor() != null && player != null) {
                player.getManaPool().addMana(choice.getMana(manaCount), game, source);
                return true;
            }
        }
        return false;
    }
}

