/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.HashMap;
import java.util.Map;
import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.cards.Card;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.watchers.Watcher;

class RadiantScrollwielderWatcher
extends Watcher {
    private final Map<MageObjectReference, MageObjectReference> morMap = new HashMap<MageObjectReference, MageObjectReference>();

    RadiantScrollwielderWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() != GameEvent.EventType.SPELL_CAST || event.getApprovingObject() == null) {
            return;
        }
        this.morMap.put(new MageObjectReference(event.getSourceId(), game), event.getApprovingObject().getApprovingMageObjectReference());
    }

    public void reset() {
        super.reset();
        this.morMap.clear();
    }

    static boolean checkSpell(Card card, Ability source, Game game) {
        if (card == null) {
            return false;
        }
        RadiantScrollwielderWatcher watcher = (RadiantScrollwielderWatcher)game.getState().getWatcher(RadiantScrollwielderWatcher.class);
        if (watcher == null) {
            return false;
        }
        MageObjectReference mor = watcher.morMap.getOrDefault(new MageObjectReference((MageObject)card, game), null);
        return mor != null && mor.refersTo(source.getSourceObject(game), game);
    }
}

