/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.keyword.ConniveSourceEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;

class RaffineSchemingSeerEffect
extends OneShotEffect {
    RaffineSchemingSeerEffect() {
        super(Outcome.Benefit);
        this.staticText = "target attacking creature connives X, where X is the number of attacking creatures. <i>(Draw X cards, then discard X cards. Put a +1/+1 counter on that creature for each nonland card discarded this way.)</i>";
    }

    private RaffineSchemingSeerEffect(RaffineSchemingSeerEffect effect) {
        super((OneShotEffect)effect);
    }

    public RaffineSchemingSeerEffect copy() {
        return new RaffineSchemingSeerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = this.getTargetPointer().getFirstTargetPermanentOrLKI(game, source);
        if (permanent == null) {
            return false;
        }
        int amount = game.getBattlefield().count((FilterPermanent)StaticFilters.FILTER_ATTACKING_CREATURES, source.getControllerId(), source, game);
        return ConniveSourceEffect.connive((Permanent)permanent, (int)amount, (Ability)source, (Game)game);
    }
}

