/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.UUID;
import mage.MageIdentifier;
import mage.abilities.Ability;
import mage.abilities.costs.Costs;
import mage.abilities.costs.CostsImpl;
import mage.abilities.costs.mana.ManaCosts;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.AsThoughEffectImpl;
import mage.constants.AsThoughEffectType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class RafinnesGuidancePlayEffect
extends AsThoughEffectImpl {
    RafinnesGuidancePlayEffect() {
        super(AsThoughEffectType.CAST_FROM_NOT_OWN_HAND_ZONE, Duration.EndOfGame, Outcome.Benefit);
        this.staticText = "You may cast {this} from your graveyard by paying {2}{W} rather than paying its mana cost.";
    }

    private RafinnesGuidancePlayEffect(RafinnesGuidancePlayEffect effect) {
        super((AsThoughEffectImpl)effect);
    }

    public boolean applies(UUID sourceId, Ability source, UUID affectedControllerId, Game game) {
        Player player;
        if (sourceId.equals(source.getSourceId()) && source.isControlledBy(affectedControllerId) && game.getState().getZone(source.getSourceId()) == Zone.GRAVEYARD && (player = game.getPlayer(affectedControllerId)) != null) {
            CostsImpl costs = new CostsImpl();
            player.setCastSourceIdWithAlternateMana(sourceId, (ManaCosts)new ManaCostsImpl("{2}{W}"), (Costs)costs, MageIdentifier.RafinnesGuidanceAlternateCast);
            return true;
        }
        return false;
    }

    public boolean apply(Game game, Ability source) {
        return true;
    }

    public RafinnesGuidancePlayEffect copy() {
        return new RafinnesGuidancePlayEffect(this);
    }
}

