/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.combat.CantBeBlockedByAllTargetEffect;
import mage.abilities.keyword.FlyingAbility;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.mageobject.AbilityPredicate;
import mage.filter.predicate.permanent.PermanentReferenceInCollectionPredicate;
import mage.game.Game;
import mage.game.combat.CombatGroup;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class RagingRiverEffect
extends OneShotEffect {
    private static final FilterPermanent filterBlockers = new FilterControlledCreaturePermanent("creatures without flying you control to assign to the \"left\" pile (creatures not chosen will be assigned to the \"right\" pile)");

    RagingRiverEffect() {
        super(Outcome.Detriment);
        this.staticText = "each defending player divides all creatures without flying they control into a \"left\" pile and a \"right\" pile. Then, for each attacking creature you control, choose \"left\" or \"right.\" That creature can't be blocked this combat except by creatures with flying and creatures in a pile with the chosen label";
    }

    private RagingRiverEffect(RagingRiverEffect effect) {
        super((OneShotEffect)effect);
    }

    public RagingRiverEffect copy() {
        return new RagingRiverEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        ArrayList<Permanent> left = new ArrayList<Permanent>();
        ArrayList<Permanent> right = new ArrayList<Permanent>();
        for (UUID defenderId : game.getCombat().getPlayerDefenders(game)) {
            Player defender = game.getPlayer(defenderId);
            if (defender == null) continue;
            ArrayList<Permanent> leftLog = new ArrayList<Permanent>();
            ArrayList<Permanent> rightLog = new ArrayList<Permanent>();
            TargetPermanent target = new TargetPermanent(0, Integer.MAX_VALUE, filterBlockers, true);
            if (!target.canChoose(defenderId, source, game)) continue;
            if (defender.chooseTarget(Outcome.Neutral, (Target)target, source, game)) {
                for (Permanent permanent2 : game.getBattlefield().getAllActivePermanents((FilterPermanent)new FilterCreaturePermanent(), defenderId, game)) {
                    if (target.getTargets().contains(permanent2.getId())) {
                        left.add(permanent2);
                        leftLog.add(permanent2);
                        continue;
                    }
                    if (!filterBlockers.match(permanent2, defenderId, source, game)) continue;
                    right.add(permanent2);
                    rightLog.add(permanent2);
                }
            }
            StringBuilder sb = new StringBuilder("Left pile of ").append(defender.getLogName()).append(": ");
            sb.append(leftLog.stream().map(MageObject::getLogName).collect(Collectors.joining(", ")));
            game.informPlayers(sb.toString());
            sb = new StringBuilder("Right pile of ").append(defender.getLogName()).append(": ");
            sb.append(rightLog.stream().map(MageObject::getLogName).collect(Collectors.joining(", ")));
            game.informPlayers(sb.toString());
        }
        for (UUID attackers : game.getCombat().getAttackers()) {
            CombatGroup combatGroup;
            Permanent attacker = game.getPermanent(attackers);
            if (attacker == null || !Objects.equals(attacker.getControllerId(), controller.getId()) || (combatGroup = game.getCombat().findGroup(attacker.getId())) == null) continue;
            FilterCreaturePermanent filter = new FilterCreaturePermanent();
            Player defender = game.getPlayer(combatGroup.getDefendingPlayerId());
            if (defender == null) continue;
            if (left.isEmpty() && right.isEmpty()) {
                filter.add(Predicates.not((Predicate)new AbilityPredicate(FlyingAbility.class)));
            } else {
                List leftLog = left.stream().filter(permanent -> permanent.getControllerId() != null).filter(permanent -> permanent.isControlledBy(defender.getId())).collect(Collectors.toList());
                List rightLog = right.stream().filter(permanent -> permanent.getControllerId() != null).filter(permanent -> permanent.isControlledBy(defender.getId())).collect(Collectors.toList());
                if (controller.choosePile(this.outcome, attacker.getName() + ": attacking " + defender.getName(), leftLog, rightLog, game)) {
                    filter.add(Predicates.not((Predicate)Predicates.or((Predicate)new AbilityPredicate(FlyingAbility.class), (Predicate)new PermanentReferenceInCollectionPredicate(left, game))));
                    game.informPlayers(attacker.getLogName() + ": attacks left (" + defender.getLogName() + ")");
                } else {
                    filter.add(Predicates.not((Predicate)Predicates.or((Predicate)new AbilityPredicate(FlyingAbility.class), (Predicate)new PermanentReferenceInCollectionPredicate(right, game))));
                    game.informPlayers(attacker.getLogName() + ": attacks right (" + defender.getLogName() + ")");
                }
            }
            CantBeBlockedByAllTargetEffect effect = new CantBeBlockedByAllTargetEffect(filter, Duration.EndOfCombat);
            effect.setTargetPointer((TargetPointer)new FixedTarget(attacker.getId(), game));
            game.addEffect((ContinuousEffect)effect, source);
        }
        return true;
    }

    static {
        filterBlockers.add(Predicates.not((Predicate)new AbilityPredicate(FlyingAbility.class)));
    }
}

