/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.counter.AddCountersTargetEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;

class RailwayBrawlerEffect
extends OneShotEffect {
    RailwayBrawlerEffect() {
        super(Outcome.Benefit);
        this.staticText = "put X +1/+1 counters on it, where X is its power";
    }

    private RailwayBrawlerEffect(RailwayBrawlerEffect effect) {
        super((OneShotEffect)effect);
    }

    public RailwayBrawlerEffect copy() {
        return new RailwayBrawlerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent creature = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (creature == null) {
            return false;
        }
        int pow = creature.getPower().getValue();
        if (pow <= 0) {
            return false;
        }
        return new AddCountersTargetEffect(CounterType.P1P1.createInstance(pow)).setTargetPointer(this.getTargetPointer().copy()).apply(game, source);
    }
}

