/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DestroyTargetEffect;
import mage.abilities.effects.common.ExileGraveyardAllTargetPlayerEffect;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPlayer;
import mage.target.common.TargetArtifactPermanent;

public final class RakdosCharm
extends CardImpl {
    public RakdosCharm(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.INSTANT}, "{B}{R}");
        this.getSpellAbility().addEffect((Effect)new ExileGraveyardAllTargetPlayerEffect());
        this.getSpellAbility().addTarget((Target)new TargetPlayer());
        Mode mode = new Mode((Effect)new DestroyTargetEffect());
        mode.addTarget((Target)new TargetArtifactPermanent());
        this.getSpellAbility().addMode(mode);
        mode = new Mode((Effect)new RakdosCharmDamageEffect());
        this.getSpellAbility().addMode(mode);
    }

    private RakdosCharm(RakdosCharm card) {
        super((CardImpl)card);
    }

    public RakdosCharm copy() {
        return new RakdosCharm(this);
    }

    private static class RakdosCharmDamageEffect
    extends OneShotEffect {
        public RakdosCharmDamageEffect() {
            super(Outcome.Detriment);
            this.staticText = "each creature deals 1 damage to its controller";
        }

        private RakdosCharmDamageEffect(RakdosCharmDamageEffect effect) {
            super((OneShotEffect)effect);
        }

        public boolean apply(Game game, Ability source) {
            FilterPermanent filter = new FilterPermanent();
            filter.add((Predicate)CardType.CREATURE.getPredicate());
            for (Permanent permanent : game.getBattlefield().getActivePermanents(filter, source.getControllerId(), source, game)) {
                Player controller = game.getPlayer(permanent.getControllerId());
                if (controller == null) continue;
                controller.damage(1, permanent.getId(), source, game);
                game.informPlayers("1 damage to " + controller.getLogName() + " from " + permanent.getName());
            }
            return true;
        }

        public RakdosCharmDamageEffect copy() {
            return new RakdosCharmDamageEffect(this);
        }
    }
}

