/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.counter.AddCountersTargetEffect;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.DamagedPlayerEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class RakishHeirTriggeredAbility
extends TriggeredAbilityImpl {
    public RakishHeirTriggeredAbility() {
        super(Zone.BATTLEFIELD, null, false);
    }

    private RakishHeirTriggeredAbility(RakishHeirTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public RakishHeirTriggeredAbility copy() {
        return new RakishHeirTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGED_PLAYER;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        DamagedPlayerEvent damageEvent = (DamagedPlayerEvent)event;
        Permanent permanent = game.getPermanent(event.getSourceId());
        if (damageEvent.isCombatDamage() && permanent != null && permanent.hasSubtype(SubType.VAMPIRE, game) && permanent.isControlledBy(this.controllerId)) {
            this.getEffects().clear();
            AddCountersTargetEffect effect = new AddCountersTargetEffect(CounterType.P1P1.createInstance());
            effect.setTargetPointer((TargetPointer)new FixedTarget(permanent, game));
            this.addEffect((Effect)effect);
            return true;
        }
        return false;
    }

    public String getRule() {
        return "Whenever a Vampire you control deals combat damage to a player, put a +1/+1 counter on it.";
    }
}

