/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.counter.AddCountersSourceEffect;
import mage.cards.Card;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeGroupEvent;

class RakshasaVizierTriggeredAbility
extends TriggeredAbilityImpl {
    RakshasaVizierTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new AddCountersSourceEffect(CounterType.P1P1.createInstance()), false);
    }

    private RakshasaVizierTriggeredAbility(RakshasaVizierTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE_GROUP;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        ZoneChangeGroupEvent zEvent = (ZoneChangeGroupEvent)event;
        if (zEvent != null && Zone.GRAVEYARD == zEvent.getFromZone() && Zone.EXILED == zEvent.getToZone() && zEvent.getCards() != null) {
            int cardCount = 0;
            for (Card card : zEvent.getCards()) {
                if (card == null || !card.isOwnedBy(this.getControllerId())) continue;
                ++cardCount;
            }
            if (cardCount == 0) {
                return false;
            }
            this.getEffects().clear();
            this.getEffects().add((Object)new AddCountersSourceEffect(CounterType.P1P1.createInstance(cardCount)));
            return true;
        }
        return false;
    }

    public String getRule() {
        return "Whenever one or more cards are put into exile from your graveyard, put that many +1/+1 counters on {this}.";
    }

    public RakshasaVizierTriggeredAbility copy() {
        return new RakshasaVizierTriggeredAbility(this);
    }
}

