/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.UUID;
import mage.MageIdentifier;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.AsThoughEffectImpl;
import mage.cards.Card;
import mage.constants.AsThoughEffectType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;

class RalLeylineProdigyCastEffect
extends AsThoughEffectImpl {
    private final MageObjectReference mor;

    public RalLeylineProdigyCastEffect(MageObjectReference mor) {
        super(AsThoughEffectType.CAST_FROM_NOT_OWN_HAND_ZONE, Duration.EndOfTurn, Outcome.Benefit);
        this.mor = mor;
    }

    private RalLeylineProdigyCastEffect(RalLeylineProdigyCastEffect effect) {
        super((AsThoughEffectImpl)effect);
        this.mor = effect.mor;
    }

    public RalLeylineProdigyCastEffect copy() {
        return new RalLeylineProdigyCastEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        return true;
    }

    public boolean applies(UUID objectId, Ability source, UUID affectedControllerId, Game game) {
        if (this.mor.getCard(game) == null) {
            this.discard();
            return false;
        }
        Card theCard = game.getCard(objectId);
        if (theCard == null || !theCard.isInstantOrSorcery(game)) {
            return false;
        }
        UUID mainId = theCard.getMainCard().getId();
        if (!source.isControlledBy(affectedControllerId) || !this.mor.refersTo(mainId, game)) {
            return false;
        }
        this.allowCardToPlayWithoutMana(mainId, source, affectedControllerId, MageIdentifier.WithoutPayingManaCostAlternateCast, game);
        return true;
    }
}

