/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.CentaurToken;

class RampageOfTheClansEffect
extends OneShotEffect {
    RampageOfTheClansEffect() {
        super(Outcome.Benefit);
        this.staticText = "Destroy all artifacts and enchantments. For each permanent destroyed this way, its controller creates a 3/3 green Centaur creature token.";
    }

    private RampageOfTheClansEffect(RampageOfTheClansEffect effect) {
        super((OneShotEffect)effect);
    }

    public RampageOfTheClansEffect copy() {
        return new RampageOfTheClansEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        HashMap<UUID, Integer> playersWithPermanents = new HashMap<UUID, Integer>();
        for (Permanent p : game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_ARTIFACT_OR_ENCHANTMENT, source.getControllerId(), source, game)) {
            UUID controllerId = p.getControllerId();
            if (!p.destroy(source, game, false)) continue;
            playersWithPermanents.put(controllerId, playersWithPermanents.getOrDefault(controllerId, 0) + 1);
        }
        game.processAction();
        CentaurToken token = new CentaurToken();
        for (Map.Entry amountDestroyedByPlayer : playersWithPermanents.entrySet()) {
            token.putOntoBattlefield(((Integer)amountDestroyedByPlayer.getValue()).intValue(), game, source, (UUID)amountDestroyedByPlayer.getKey());
        }
        return true;
    }
}

