/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.Effect;
import mage.constants.CardType;
import mage.filter.FilterPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.permanent.ControllerIdPredicate;
import mage.filter.predicate.permanent.ProtectorIdPredicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;
import mage.target.targetadjustment.TargetAdjuster;
import mage.target.targetpointer.FirstTargetPointer;
import mage.target.targetpointer.TargetPointer;

enum RampagingRaptorTargetAdjuster implements TargetAdjuster
{
    instance;


    public void adjustTargets(Ability ability, Game game) {
        UUID opponentId = ((Effect)ability.getEffects().get(0)).getTargetPointer().getFirst(game, ability);
        Player opponent = game.getPlayer(opponentId);
        ability.getTargets().clear();
        ability.getAllEffects().setTargetPointer((TargetPointer)new FirstTargetPointer());
        if (opponent == null) {
            return;
        }
        FilterPermanent filter = new FilterPermanent("planeswalker " + opponent.getLogName() + " controls or battle " + opponent.getLogName() + " protects");
        filter.add(Predicates.or((Predicate)Predicates.and((Predicate)CardType.PLANESWALKER.getPredicate(), (Predicate)new ControllerIdPredicate(opponent.getId())), (Predicate)Predicates.and((Predicate)CardType.BATTLE.getPredicate(), (Predicate)new ProtectorIdPredicate(opponent.getId()))));
        ability.addTarget((Target)new TargetPermanent(filter));
    }
}

