/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.Ability;
import mage.abilities.costs.mana.ManaCost;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.common.cost.CostModificationEffectImpl;
import mage.abilities.keyword.ForetellAbility;
import mage.constants.CostModificationType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.watchers.common.ForetoldWatcher;

class RanarTheEverWatchfulCostReductionEffect
extends CostModificationEffectImpl {
    RanarTheEverWatchfulCostReductionEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Neutral, CostModificationType.REDUCE_COST);
        this.staticText = "The first card you foretell each turn costs {0} to foretell";
    }

    private RanarTheEverWatchfulCostReductionEffect(RanarTheEverWatchfulCostReductionEffect effect) {
        super((CostModificationEffectImpl)effect);
    }

    public RanarTheEverWatchfulCostReductionEffect copy() {
        return new RanarTheEverWatchfulCostReductionEffect(this);
    }

    public boolean apply(Game game, Ability source, Ability abilityToModify) {
        abilityToModify.clearManaCostsToPay();
        abilityToModify.addManaCostsToPay((ManaCost)new ManaCostsImpl("{0}"));
        return true;
    }

    public boolean applies(Ability abilityToModify, Ability source, Game game) {
        ForetoldWatcher watcher = (ForetoldWatcher)game.getState().getWatcher(ForetoldWatcher.class);
        return watcher != null && watcher.getPlayerForetellCountThisTurn(source.getControllerId()) == 0 && abilityToModify.isControlledBy(source.getControllerId()) && abilityToModify instanceof ForetellAbility;
    }
}

