/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.common.delayed.AtTheBeginOfNextEndStepDelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ReturnToHandTargetEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.keyword.HasteAbility;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.targetpointer.FixedTargets;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;

class RandomEncounterEffect
extends OneShotEffect {
    RandomEncounterEffect() {
        super(Outcome.Benefit);
        this.staticText = "shuffle your library, then mill four cards. Put each creature card milled this way onto the battlefield. They gain haste. At the beginning of the next end step, return those creatures to their owner's hand";
    }

    private RandomEncounterEffect(RandomEncounterEffect effect) {
        super((OneShotEffect)effect);
    }

    public RandomEncounterEffect copy() {
        return new RandomEncounterEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null || !player.getLibrary().hasCards()) {
            return false;
        }
        player.shuffleLibrary(source, game);
        CardsImpl cards = new CardsImpl(player.millCards(4, source, game).getCards((FilterCard)StaticFilters.FILTER_CARD_CREATURE, game));
        player.moveCards((Cards)cards, Zone.BATTLEFIELD, source, game);
        Set permanents = cards.getCards(game).stream().map(card -> CardUtil.getPermanentFromCardPutToBattlefield((Card)card, (Game)game)).filter(Objects::nonNull).collect(Collectors.toSet());
        game.addEffect(new GainAbilityTargetEffect((Ability)HasteAbility.getInstance(), Duration.Custom).setTargetPointer((TargetPointer)new FixedTargets(permanents, game)), source);
        game.addDelayedTriggeredAbility((DelayedTriggeredAbility)new AtTheBeginOfNextEndStepDelayedTriggeredAbility((Effect)new ReturnToHandTargetEffect().setText("return those creatures to their owner's hand").setTargetPointer((TargetPointer)new FixedTargets(permanents, game))), source);
        return true;
    }
}

