/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.CardUtil;

class RankleAndTorbranEffect
extends ReplacementEffectImpl {
    RankleAndTorbranEffect() {
        super(Duration.EndOfTurn, Outcome.Benefit);
        this.staticText = "if a source would deal damage to a player or battle this turn, it deals that much damage plus 2 instead";
    }

    private RankleAndTorbranEffect(RankleAndTorbranEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGE_PERMANENT || event.getType() == GameEvent.EventType.DAMAGE_PLAYER;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        if (event.getAmount() < 1) {
            return false;
        }
        Player player = game.getPlayer(event.getTargetId());
        if (player != null) {
            return true;
        }
        Permanent permanent = game.getPermanent(event.getTargetId());
        return permanent != null && permanent.isBattle(game);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        event.setAmount(CardUtil.overflowInc((int)event.getAmount(), (int)2));
        return false;
    }

    public RankleAndTorbranEffect copy() {
        return new RankleAndTorbranEffect(this);
    }
}

