/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.keyword.RampageAbility;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class RapidFireEffect
extends OneShotEffect {
    RapidFireEffect() {
        super(Outcome.AddAbility);
        this.staticText = "If it doesn't have rampage, that creature gains rampage 2 until end of turn";
    }

    private RapidFireEffect(RapidFireEffect effect) {
        super((OneShotEffect)effect);
    }

    public RapidFireEffect copy() {
        return new RapidFireEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (controller != null && permanent != null && !permanent.getAbilities().containsClass(RampageAbility.class)) {
            GainAbilityTargetEffect effect = new GainAbilityTargetEffect((Ability)new RampageAbility(2), Duration.EndOfTurn);
            effect.setTargetPointer((TargetPointer)new FixedTarget(permanent, game));
            game.addEffect((ContinuousEffect)effect, source);
        }
        return false;
    }
}

