/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.ObjectColor;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.constants.Zone;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ColorPredicate;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class RashkaTheSlayerTriggeredAbility
extends TriggeredAbilityImpl {
    private static final FilterCreaturePermanent filter = new FilterCreaturePermanent("black creature");

    public RashkaTheSlayerTriggeredAbility(Effect effect) {
        super(Zone.BATTLEFIELD, effect, false);
        this.setTriggerPhrase("Whenever {this} blocks a " + filter.getMessage() + ", ");
    }

    private RashkaTheSlayerTriggeredAbility(RashkaTheSlayerTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.BLOCKER_DECLARED;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent blocked;
        return event.getSourceId().equals(this.getSourceId()) && (blocked = game.getPermanent(event.getTargetId())) != null && filter.match((Object)blocked, game);
    }

    public RashkaTheSlayerTriggeredAbility copy() {
        return new RashkaTheSlayerTriggeredAbility(this);
    }

    static {
        filter.add((Predicate)new ColorPredicate(ObjectColor.BLACK));
    }
}

