/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.ComparisonType;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.game.Game;
import mage.game.stack.Spell;
import mage.players.Player;
import mage.util.CardUtil;

class RashmiEternitiesCrafterEffect
extends OneShotEffect {
    RashmiEternitiesCrafterEffect() {
        super(Outcome.PlayForFree);
        this.staticText = "reveal the top card of your library. You may cast it without paying its mana cost if it's a spell with lesser mana value. If you don't cast it, put it into your hand.";
    }

    private RashmiEternitiesCrafterEffect(RashmiEternitiesCrafterEffect effect) {
        super((OneShotEffect)effect);
    }

    public RashmiEternitiesCrafterEffect copy() {
        return new RashmiEternitiesCrafterEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Spell spell = (Spell)this.getValue("spellCast");
        if (player == null || spell == null) {
            return false;
        }
        Card card = player.getLibrary().getFromTop(game);
        if (card == null) {
            return false;
        }
        player.revealCards("Rashmi, Eternities Crafter", (Cards)new CardsImpl(card), game);
        FilterCard filter = new FilterCard();
        filter.add((Predicate)new ManaValuePredicate(ComparisonType.FEWER_THAN, spell.getManaValue()));
        CardUtil.castSpellWithAttributesForFree((Player)player, (Ability)source, (Game)game, (Card)card, (FilterCard)filter);
        if (Zone.LIBRARY.match(game.getState().getZone(card.getId()))) {
            player.moveCards(card, Zone.HAND, source, game);
        }
        return true;
    }
}

