/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.Set;
import java.util.UUID;
import mage.abilities.Ability;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.TargetPermanent;

class RavagerOfTheFellsTarget
extends TargetPermanent {
    RavagerOfTheFellsTarget() {
        super(0, 1, (FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE);
    }

    private RavagerOfTheFellsTarget(RavagerOfTheFellsTarget target) {
        super((TargetPermanent)target);
    }

    public Set<UUID> possibleTargets(UUID sourceControllerId, Ability source, Game game) {
        Set possibleTargets = super.possibleTargets(sourceControllerId, source, game);
        Player needPlayer = game.getPlayerOrPlaneswalkerController(source.getFirstTarget());
        if (needPlayer != null) {
            possibleTargets.removeIf(id -> {
                Permanent permanent = game.getPermanent(id);
                return permanent == null || permanent.getId().equals(source.getFirstTarget()) || !permanent.isControlledBy(needPlayer.getId());
            });
        }
        return possibleTargets;
    }

    public RavagerOfTheFellsTarget copy() {
        return new RavagerOfTheFellsTarget(this);
    }
}

