/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.players.Player;

class RavenloftAdventurerLifeEffect
extends OneShotEffect {
    RavenloftAdventurerLifeEffect() {
        super(Outcome.Benefit);
        this.staticText = "defending player loses 1 life for each card they own in exile with a hit counter on it";
    }

    private RavenloftAdventurerLifeEffect(RavenloftAdventurerLifeEffect effect) {
        super((OneShotEffect)effect);
    }

    public RavenloftAdventurerLifeEffect copy() {
        return new RavenloftAdventurerLifeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (player == null) {
            return false;
        }
        int count = game.getExile().getCardsOwned(game, player.getId()).stream().filter(card -> card.getCounters(game).containsKey(CounterType.HIT)).mapToInt(x -> 1).sum();
        return count > 0 && player.loseLife(count, game, source, false) > 0;
    }
}

