/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.Target;

class RavenousGigantotheriumEffect
extends OneShotEffect {
    RavenousGigantotheriumEffect() {
        super(Outcome.Benefit);
        this.setText("Each of those creatures deals damage equal to its power to {this}.");
    }

    private RavenousGigantotheriumEffect(RavenousGigantotheriumEffect effect) {
        super((OneShotEffect)effect);
    }

    public RavenousGigantotheriumEffect copy() {
        return new RavenousGigantotheriumEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent sourcePerm = game.getPermanent(source.getSourceId());
        if (sourcePerm == null) {
            return false;
        }
        List permanentList = source.getTargets().stream().map(Target::getTargets).flatMap(Collection::stream).map(arg_0 -> ((Game)game).getPermanent(arg_0)).filter(Objects::nonNull).collect(Collectors.toList());
        for (Permanent permanent : permanentList) {
            sourcePerm.damage(permanent.getPower().getValue(), permanent.getId(), source, game);
        }
        return true;
    }
}

