/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.common.delayed.ReflexiveTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.SacrificeOpponentsEffect;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.common.FilterControlledPermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;

class RavenousRotbellyEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterControlledPermanent(SubType.ZOMBIE, "Zombies you control");

    RavenousRotbellyEffect() {
        super(Outcome.Benefit);
        this.staticText = "you may sacrifice up to three Zombies. When you sacrifice one or more Zombies this way, each opponent sacrifices that many creatures";
    }

    private RavenousRotbellyEffect(RavenousRotbellyEffect effect) {
        super((OneShotEffect)effect);
    }

    public RavenousRotbellyEffect copy() {
        return new RavenousRotbellyEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        TargetPermanent target = new TargetPermanent(0, 3, filter, true);
        player.choose(this.outcome, (Target)target, source, game);
        int amount = 0;
        for (UUID permanentId : target.getTargets()) {
            Permanent permanent = game.getPermanent(permanentId);
            if (permanent == null || !permanent.sacrifice(source, game)) continue;
            ++amount;
        }
        if (amount < 1) {
            return false;
        }
        game.fireReflexiveTriggeredAbility(new ReflexiveTriggeredAbility((Effect)new SacrificeOpponentsEffect(amount, (FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURES), false, "each opponent sacrifices that many creatures"), source);
        return true;
    }
}

