/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.RedirectionEffect;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.target.Target;

class RaziaBorosArchangelEffect
extends RedirectionEffect {
    protected MageObjectReference redirectToObject;

    public RaziaBorosArchangelEffect(Duration duration, int amount) {
        super(duration, amount, RedirectionEffect.UsageType.ACCORDING_DURATION);
        this.staticText = "The next " + amount + " damage that would be dealt to target creature you control this turn is dealt to another target creature instead";
    }

    private RaziaBorosArchangelEffect(RaziaBorosArchangelEffect effect) {
        super((RedirectionEffect)effect);
    }

    public RaziaBorosArchangelEffect copy() {
        return new RaziaBorosArchangelEffect(this);
    }

    public void init(Ability source, Game game) {
        super.init(source, game);
        this.redirectToObject = new MageObjectReference(((Target)source.getTargets().get(1)).getFirstTarget(), game);
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        if (event.getTargetId().equals(this.getTargetPointer().getFirst(game, source)) && game.getControllerId(this.redirectToObject.getSourceId()) != null && this.redirectToObject.equals((Object)new MageObjectReference(((Target)source.getTargets().get(1)).getFirstTarget(), game))) {
            this.redirectTarget = (Target)source.getTargets().get(1);
            return true;
        }
        return false;
    }
}

