/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class RazorHippogriffGainLifeEffect
extends OneShotEffect {
    RazorHippogriffGainLifeEffect() {
        super(Outcome.GainLife);
        this.staticText = "you gain life equal to that card's mana value.";
    }

    private RazorHippogriffGainLifeEffect(RazorHippogriffGainLifeEffect effect) {
        super((OneShotEffect)effect);
    }

    public RazorHippogriffGainLifeEffect copy() {
        return new RazorHippogriffGainLifeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Card card = game.getCard(source.getFirstTarget());
        if (player != null && card != null) {
            player.gainLife(card.getManaValue(), game, source);
            return true;
        }
        return false;
    }
}

