/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.Mana;
import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.choices.Choice;
import mage.choices.ChoiceColor;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.TappedForManaEvent;
import mage.game.permanent.Permanent;
import mage.players.Player;

class RealityTwistEffect
extends ReplacementEffectImpl {
    RealityTwistEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Neutral);
        this.staticText = "If tapped for mana, Plains produce {R}, Swamps produce {G}, Mountains produce {W}, and Forests produce {B} instead of any other type";
    }

    private RealityTwistEffect(RealityTwistEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public RealityTwistEffect copy() {
        return new RealityTwistEffect(this);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        String chosenColor;
        TappedForManaEvent manaEvent = (TappedForManaEvent)event;
        Player controller = game.getPlayer(source.getControllerId());
        Permanent permanent = manaEvent.getPermanent();
        if (controller == null || permanent == null) {
            return false;
        }
        ChoiceColor choice = new ChoiceColor(true);
        choice.getChoices().clear();
        choice.setMessage("Pick a color to produce");
        if (permanent.hasSubtype(SubType.PLAINS, game)) {
            choice.getChoices().add("Red");
        }
        if (permanent.hasSubtype(SubType.SWAMP, game)) {
            choice.getChoices().add("Green");
        }
        if (permanent.hasSubtype(SubType.MOUNTAIN, game)) {
            choice.getChoices().add("White");
        }
        if (permanent.hasSubtype(SubType.FOREST, game)) {
            choice.getChoices().add("Black");
        }
        if (choice.getChoices().size() == 1) {
            chosenColor = (String)choice.getChoices().iterator().next();
        } else if (choice.getChoices().size() == 0) {
            chosenColor = null;
        } else if (game.inCheckPlayableState()) {
            chosenColor = "Any";
        } else {
            controller.choose(Outcome.PutManaInPool, (Choice)choice, game);
            chosenColor = choice.getChoice();
        }
        if (chosenColor == null) {
            return false;
        }
        Mana mana = manaEvent.getMana();
        int amount = mana.count();
        switch (chosenColor) {
            case "White": {
                mana.setToMana(Mana.WhiteMana((int)amount));
                break;
            }
            case "Black": {
                mana.setToMana(Mana.BlackMana((int)amount));
                break;
            }
            case "Red": {
                mana.setToMana(Mana.RedMana((int)amount));
                break;
            }
            case "Green": {
                mana.setToMana(Mana.GreenMana((int)amount));
                break;
            }
            case "Any": {
                mana.setToMana(Mana.AnyMana((int)amount));
            }
        }
        return false;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.TAPPED_FOR_MANA;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Permanent permanent = ((TappedForManaEvent)event).getPermanent();
        return permanent != null && (permanent.hasSubtype(SubType.PLAINS, game) || permanent.hasSubtype(SubType.SWAMP, game) || permanent.hasSubtype(SubType.MOUNTAIN, game) || permanent.hasSubtype(SubType.FOREST, game));
    }
}

