/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.UUID;
import mage.ObjectColor;
import mage.abilities.Ability;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.FilterPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ColorPredicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInYourGraveyard;
import mage.target.common.TargetOpponent;
import mage.target.targetadjustment.TargetAdjuster;

enum ReapAdjuster implements TargetAdjuster
{
    instance;

    private static final FilterPermanent filter;

    public void adjustTargets(Ability ability, Game game) {
        Player controller = game.getPlayer(ability.getControllerId());
        if (controller != null) {
            ability.getTargets().clear();
            UUID opponentId = null;
            TargetOpponent target = new TargetOpponent();
            if (controller.chooseTarget(Outcome.ReturnToHand, (Target)target, ability, game)) {
                opponentId = target.getFirstTarget();
            }
            int numbTargets = game.getBattlefield().getAllActivePermanents(filter, opponentId, game).size();
            ability.addTarget((Target)new TargetCardInYourGraveyard(0, numbTargets, new FilterCard("card" + (numbTargets == 1 ? "" : "s") + " from your graveyard")));
        }
    }

    static {
        filter = new FilterPermanent("black permanents");
        filter.add((Predicate)new ColorPredicate(ObjectColor.BLACK));
    }
}

