/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.ArrayList;
import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.mageobject.NamePredicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInGraveyard;
import mage.target.common.TargetCardInLibrary;
import mage.util.CardUtil;

class ReapIntellectEffect
extends OneShotEffect {
    private static final FilterCard filterNonLands = new FilterCard("up to X nonland cards");

    public ReapIntellectEffect() {
        super(Outcome.Exile);
        this.staticText = "Target opponent reveals their hand. You choose up to X nonland cards from it and exile them. For each card exiled this way, search that player's graveyard, hand, and library for any number of cards with the same name as that card and exile them. Then that player shuffles";
    }

    private ReapIntellectEffect(ReapIntellectEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player targetPlayer = game.getPlayer(source.getFirstTarget());
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = game.getObject(source);
        if (targetPlayer != null && sourceObject != null && controller != null) {
            targetPlayer.revealCards(sourceObject.getName(), targetPlayer.getHand(), game);
            CardsImpl exiledCards = new CardsImpl();
            int xCost = Math.min((Integer)CardUtil.getSourceCostsTag((Game)game, (Ability)source, (String)"X", (Object)0), targetPlayer.getHand().size());
            TargetCard target = new TargetCard(0, xCost, Zone.HAND, filterNonLands);
            target.withNotTarget(true);
            controller.choose(Outcome.Benefit, targetPlayer.getHand(), target, source, game);
            for (UUID cardId : target.getTargets()) {
                Card chosenCard = game.getCard(cardId);
                if (chosenCard == null) continue;
                controller.moveCardToExileWithInfo(chosenCard, null, "", source, game, Zone.HAND, true);
                exiledCards.add(chosenCard);
            }
            if (!exiledCards.isEmpty()) {
                ArrayList<NamePredicate> names = new ArrayList<NamePredicate>();
                FilterCard filterNamedCards = new FilterCard();
                for (Object card : exiledCards.getCards(game)) {
                    String nameToSearch = CardUtil.getCardNameForSameNameSearch((Card)card);
                    if (exiledCards.size() == 1) {
                        filterNamedCards.add((Predicate)new NamePredicate(nameToSearch));
                        continue;
                    }
                    names.add(new NamePredicate(nameToSearch));
                }
                if (exiledCards.size() > 1) {
                    filterNamedCards.add(Predicates.or(names));
                }
                TargetCardInGraveyard targetCardsGraveyard = new TargetCardInGraveyard(0, Integer.MAX_VALUE, filterNamedCards);
                controller.chooseTarget(this.outcome, (Cards)targetPlayer.getGraveyard(), (TargetCard)targetCardsGraveyard, source, game);
                for (Object cardId : targetCardsGraveyard.getTargets()) {
                    Card card = game.getCard((UUID)cardId);
                    if (card == null) continue;
                    controller.moveCardToExileWithInfo(card, null, "", source, game, Zone.GRAVEYARD, true);
                }
                TargetCard targetCardsHand = new TargetCard(0, Integer.MAX_VALUE, Zone.HAND, filterNamedCards);
                controller.chooseTarget(Outcome.Benefit, (Cards)targetPlayer.getGraveyard(), targetCardsHand, source, game);
                for (UUID cardId : targetCardsHand.getTargets()) {
                    Card card = game.getCard(cardId);
                    if (card == null) continue;
                    controller.moveCardToExileWithInfo(card, null, "", source, game, Zone.HAND, true);
                }
                TargetCardInLibrary targetCardsLibrary = new TargetCardInLibrary(0, Integer.MAX_VALUE, filterNamedCards);
                controller.searchLibrary(targetCardsLibrary, source, game, targetPlayer.getId());
                for (UUID cardId : targetCardsLibrary.getTargets()) {
                    Card card = game.getCard(cardId);
                    if (card == null) continue;
                    controller.moveCardToExileWithInfo(card, null, "", source, game, Zone.LIBRARY, true);
                }
            }
            targetPlayer.shuffleLibrary(source, game);
            return true;
        }
        return false;
    }

    public ReapIntellectEffect copy() {
        return new ReapIntellectEffect(this);
    }

    static {
        filterNonLands.add(Predicates.not((Predicate)CardType.LAND.getPredicate()));
    }
}

