/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.DwarfBerserkerToken;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;

class RecklessCrewEffect
extends OneShotEffect {
    private static final FilterPermanent filter1 = new FilterControlledPermanent(SubType.EQUIPMENT);
    private static final FilterPermanent filter2 = new FilterControlledPermanent(SubType.VEHICLE);

    RecklessCrewEffect() {
        super(Outcome.Benefit);
        this.staticText = "create X 2/1 red Dwarf Berserker creature tokens, where X is the number of Vehicles you control plus the number of Equipment you control. For each of those tokens, you may attach an Equipment you control to it";
    }

    private RecklessCrewEffect(RecklessCrewEffect effect) {
        super((OneShotEffect)effect);
    }

    public RecklessCrewEffect copy() {
        return new RecklessCrewEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        int vehicleCount;
        int equipCount = game.getBattlefield().count(filter1, source.getControllerId(), source, game);
        if (equipCount + (vehicleCount = game.getBattlefield().count(filter2, source.getControllerId(), source, game)) < 1) {
            return false;
        }
        DwarfBerserkerToken token = new DwarfBerserkerToken();
        token.putOntoBattlefield(equipCount + vehicleCount, game, source, source.getControllerId());
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        if (equipCount < 1) {
            return true;
        }
        for (UUID tokenId : token.getLastAddedTokenIds()) {
            Permanent permanent = game.getPermanent(tokenId);
            if (permanent == null) continue;
            TargetPermanent target = new TargetPermanent(0, 1, filter1, true);
            target.withChooseHint("(to attach to " + permanent.getIdName() + ")");
            player.choose(this.outcome, (Target)target, source, game);
            permanent.addAttachment(target.getFirstTarget(), source, game);
        }
        return true;
    }
}

