/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.r.RecommissionCounterEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class RecommissionEffect
extends OneShotEffect {
    RecommissionEffect() {
        super(Outcome.PutCardInPlay);
        this.staticText = "Return target artifact or creature card with mana value 3 or less from your graveyard to the battlefield. If a creature enters the battlefield this way, it enters with an additional +1/+1 counter on it.";
    }

    private RecommissionEffect(RecommissionEffect effect) {
        super((OneShotEffect)effect);
    }

    public RecommissionEffect copy() {
        return new RecommissionEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Card card = game.getCard(this.getTargetPointer().getFirst(game, source));
        if (controller == null || card == null) {
            return false;
        }
        game.addEffect((ContinuousEffect)new RecommissionCounterEffect(), source);
        controller.moveCards(card, Zone.BATTLEFIELD, source, game);
        return true;
    }
}

