/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.Ability;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.SacrificeControllerEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;

class RedcapMeleeEffect
extends OneShotEffect {
    private static final Effect effect = new SacrificeControllerEffect((FilterPermanent)StaticFilters.FILTER_LAND, 1, "");

    RedcapMeleeEffect() {
        super(Outcome.Damage);
        this.staticText = "{this} deals 4 damage to target creature or planeswalker. If a nonred permanent is dealt damage this way, you sacrifice a land.";
    }

    private RedcapMeleeEffect(RedcapMeleeEffect effect) {
        super((OneShotEffect)effect);
    }

    public RedcapMeleeEffect copy() {
        return new RedcapMeleeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        if (permanent == null) {
            return false;
        }
        boolean isRed = permanent.getColor(game).isRed();
        if (permanent.damage(4, source.getSourceId(), source, game) > 0 && !isRed) {
            return effect.apply(game, source);
        }
        return true;
    }
}

