/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.Objects;
import mage.MageInt;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostSourceEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.ExileZone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.util.CardUtil;

class RedemptorDreadnoughtEffect
extends OneShotEffect {
    RedemptorDreadnoughtEffect() {
        super(Outcome.BoostCreature);
        this.staticText = "if a card is exiled with it, it gets +X/+X until end of turn, where X is the power of the exiled card";
    }

    private RedemptorDreadnoughtEffect(RedemptorDreadnoughtEffect effect) {
        super((OneShotEffect)effect);
    }

    public RedemptorDreadnoughtEffect copy() {
        return new RedemptorDreadnoughtEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = source.getSourcePermanentIfItStillExists(game);
        if (permanent == null) {
            return false;
        }
        ExileZone exile = game.getExile().getExileZone(CardUtil.getExileZoneId((Game)game, (Ability)source, (int)-1));
        if (exile == null || exile.isEmpty()) {
            return false;
        }
        int xValue = exile.getCards(game).stream().filter(Objects::nonNull).map(MageObject::getPower).mapToInt(MageInt::getValue).sum();
        if (xValue > 0) {
            game.addEffect((ContinuousEffect)new BoostSourceEffect(xValue, xValue, Duration.EndOfTurn), source);
        }
        return true;
    }
}

