/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInHand;

class RedshiftRocketeerChiefEffect
extends OneShotEffect {
    RedshiftRocketeerChiefEffect() {
        super(Outcome.Benefit);
        this.staticText = "put any number of permanent cards from your hand onto the battlefield";
    }

    private RedshiftRocketeerChiefEffect(RedshiftRocketeerChiefEffect effect) {
        super((OneShotEffect)effect);
    }

    public RedshiftRocketeerChiefEffect copy() {
        return new RedshiftRocketeerChiefEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        TargetCardInHand target = new TargetCardInHand(0, Integer.MAX_VALUE, (FilterCard)StaticFilters.FILTER_CARD_PERMANENTS);
        player.choose(this.outcome, player.getHand(), (TargetCard)target, source, game);
        CardsImpl cards = new CardsImpl((Collection)target.getTargets());
        return !cards.isEmpty() && player.moveCards((Cards)cards, Zone.BATTLEFIELD, source, game);
    }
}

